/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.updater;

import com.google.gson.Gson;
import com.nexvor.Nexvor;
import com.nexvor.updater.UpdateResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class UpdateChecker
implements Listener {
    private final Nexvor plugin;
    private final HttpClient httpClient;
    private final Gson gson;
    private final String updateUrl;
    private final String currentVersion;
    private UpdateResponse latestUpdate;
    private long lastCheckTime = 0L;
    private static final long CHECK_INTERVAL_MS = 86400000L;

    public UpdateChecker(Nexvor plugin, String updateUrl) {
        this.plugin = plugin;
        this.updateUrl = updateUrl;
        this.currentVersion = plugin.getDescription().getVersion();
        this.gson = new Gson();
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
        if (plugin.getConfigManager().isUpdateNotifyOps()) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        }
    }

    public CompletableFuture<UpdateResponse> checkForUpdatesAsync() {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.updateUrl)).header("User-Agent", "Nexvor/" + this.currentVersion).GET().timeout(Duration.ofSeconds(10L)).build();
            return ((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
                if (response.statusCode() == 200) {
                    try {
                        UpdateResponse updateResponse;
                        this.latestUpdate = updateResponse = this.gson.fromJson((String)response.body(), UpdateResponse.class);
                        this.lastCheckTime = System.currentTimeMillis();
                        if (updateResponse.isUpdateAvailable(this.currentVersion)) {
                            this.plugin.getNexvorLogger().warn("Update available: v" + updateResponse.getLatestVersion() + " (current: v" + this.currentVersion + ")");
                            if (updateResponse.isCritical()) {
                                this.plugin.getNexvorLogger().warn("This is a CRITICAL update! Please update as soon as possible.");
                            }
                        } else {
                            this.plugin.getNexvorLogger().info("Plugin is up to date (v" + this.currentVersion + ")");
                        }
                        return updateResponse;
                    }
                    catch (Exception e) {
                        this.plugin.getNexvorLogger().warn("Failed to parse update response: " + e.getMessage());
                        return this.createErrorResponse();
                    }
                }
                this.plugin.getNexvorLogger().warn("Update check failed with status code: " + response.statusCode());
                return this.createErrorResponse();
            })).exceptionally(throwable -> {
                this.plugin.getNexvorLogger().warn("Update check failed: " + throwable.getMessage());
                return this.createErrorResponse();
            });
        }
        catch (Exception e) {
            this.plugin.getNexvorLogger().warn("Failed to create update check request: " + e.getMessage());
            return CompletableFuture.completedFuture(this.createErrorResponse());
        }
    }

    public UpdateResponse checkForUpdatesSync() {
        try {
            return this.checkForUpdatesAsync().get();
        }
        catch (Exception e) {
            this.plugin.getNexvorLogger().warn("Synchronous update check failed: " + e.getMessage());
            return this.createErrorResponse();
        }
    }

    public CompletableFuture<Boolean> downloadUpdateAsync() {
        if (this.latestUpdate == null || !this.latestUpdate.isUpdateAvailable(this.currentVersion)) {
            return CompletableFuture.completedFuture(false);
        }
        String downloadUrl = this.latestUpdate.getDownloadUrl();
        if (downloadUrl == null || downloadUrl.isEmpty()) {
            this.plugin.getNexvorLogger().warn("No download URL available for update");
            return CompletableFuture.completedFuture(false);
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                File updatesFolder = new File(this.plugin.getDataFolder().getParentFile(), "updates");
                if (!updatesFolder.exists()) {
                    updatesFolder.mkdirs();
                }
                String fileName = "nexvor-" + this.latestUpdate.getLatestVersion() + ".jar";
                File outputFile = new File(updatesFolder, fileName);
                this.plugin.getNexvorLogger().info("Downloading update to: " + outputFile.getPath());
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(downloadUrl)).GET().timeout(Duration.ofMinutes(5L)).build();
                HttpResponse<InputStream> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
                if (response.statusCode() == 200) {
                    try (InputStream in = response.body();
                         ReadableByteChannel rbc = Channels.newChannel(in);
                         FileOutputStream fos = new FileOutputStream(outputFile);){
                        fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                    }
                    this.plugin.getNexvorLogger().info("Update downloaded successfully!");
                    this.plugin.getNexvorLogger().info("Restart your server to apply the update.");
                    return true;
                }
                this.plugin.getNexvorLogger().warn("Download failed with status code: " + response.statusCode());
                return false;
            }
            catch (Exception e) {
                this.plugin.getNexvorLogger().warn("Failed to download update: " + e.getMessage());
                return false;
            }
        });
    }

    public UpdateResponse getLatestUpdate() {
        return this.latestUpdate;
    }

    public boolean isUpdateAvailable() {
        return this.latestUpdate != null && this.latestUpdate.isUpdateAvailable(this.currentVersion);
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public boolean shouldCheck() {
        long currentTime = System.currentTimeMillis();
        return currentTime - this.lastCheckTime >= 86400000L;
    }

    public void performPeriodicCheck() {
        if (!this.plugin.getConfigManager().isUpdateCheckEnabled()) {
            return;
        }
        if (!this.shouldCheck()) {
            return;
        }
        this.checkForUpdatesAsync().thenAccept(response -> {
            if (response.isUpdateAvailable(this.currentVersion) && this.plugin.getConfigManager().isUpdateAutoDownload()) {
                this.downloadUpdateAsync();
            }
        });
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.isOp()) {
            return;
        }
        if (!this.plugin.getConfigManager().isUpdateNotifyOps()) {
            return;
        }
        if (!this.isUpdateAvailable()) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            player.sendMessage("\u00a7e[Nexvor] \u00a7aUpdate available: \u00a7fv" + this.latestUpdate.getLatestVersion() + " \u00a77(current: v" + this.currentVersion + ")");
            if (this.latestUpdate.isCritical()) {
                player.sendMessage("\u00a7e[Nexvor] \u00a7c\u26a0 This is a CRITICAL update!");
            }
            player.sendMessage("\u00a7e[Nexvor] \u00a77Use \u00a7f/nexvor update info \u00a77for details");
        }, 60L);
    }

    private UpdateResponse createErrorResponse() {
        UpdateResponse response = new UpdateResponse();
        response.setLatestVersion(this.currentVersion);
        return response;
    }

    public void shutdown() {
    }
}

