/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.memory;

import com.nexvor.Nexvor;
import com.nexvor.ai.models.ChatMessage;
import com.nexvor.memory.DatabaseManager;
import com.nexvor.memory.GroupConversation;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class GroupConversationManager {
    private final Nexvor plugin;
    private final DatabaseManager databaseManager;

    public GroupConversationManager(Nexvor plugin, DatabaseManager databaseManager) {
        this.plugin = plugin;
        this.databaseManager = databaseManager;
    }

    public GroupConversation createGroup(String groupName, UUID ownerUuid) {
        GroupConversation groupConversation;
        block22: {
            String groupId = UUID.randomUUID().toString();
            long now = System.currentTimeMillis();
            String insertGroup = "INSERT INTO conversation_groups (group_id, group_name, owner_uuid, created_at, active) VALUES (?, ?, ?, ?, 1)";
            String insertMember = "INSERT INTO group_members (group_id, player_uuid, joined_at) VALUES (?, ?, ?)";
            Connection conn = this.databaseManager.getConnection();
            try {
                conn.setAutoCommit(false);
                try (PreparedStatement stmt = conn.prepareStatement(insertGroup);){
                    stmt.setString(1, groupId);
                    stmt.setString(2, groupName);
                    stmt.setString(3, ownerUuid.toString());
                    stmt.setLong(4, now);
                    stmt.executeUpdate();
                }
                stmt = conn.prepareStatement(insertMember);
                try {
                    stmt.setString(1, groupId);
                    stmt.setString(2, ownerUuid.toString());
                    stmt.setLong(3, now);
                    stmt.executeUpdate();
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                conn.commit();
                this.plugin.getNexvorLogger().info("Group created: " + groupName + " (ID: " + groupId + ")");
                groupConversation = new GroupConversation(groupId, groupName, ownerUuid);
                if (conn == null) break block22;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.plugin.getNexvorLogger().error("Failed to create group: " + groupName, e);
                    return null;
                }
            }
            conn.close();
        }
        return groupConversation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GroupConversation getGroup(String groupId) {
        String query = "SELECT group_id, group_name, owner_uuid, created_at, active FROM conversation_groups WHERE group_id = ?";
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(query);){
            stmt.setString(1, groupId);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return null;
            UUID ownerUuid = UUID.fromString(rs.getString("owner_uuid"));
            List<UUID> members = this.getGroupMembers(groupId);
            GroupConversation groupConversation = new GroupConversation(rs.getString("group_id"), rs.getString("group_name"), ownerUuid, members, rs.getLong("created_at"), rs.getInt("active") == 1);
            return groupConversation;
        }
        catch (SQLException e) {
            this.plugin.getNexvorLogger().error("Failed to get group: " + groupId, e);
        }
        return null;
    }

    public List<GroupConversation> getAllActiveGroups() {
        ArrayList<GroupConversation> groups = new ArrayList<GroupConversation>();
        String query = "SELECT group_id, group_name, owner_uuid, created_at, active FROM conversation_groups WHERE active = 1";
        try (Connection conn = this.databaseManager.getConnection();
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(query);){
            while (rs.next()) {
                UUID ownerUuid = UUID.fromString(rs.getString("owner_uuid"));
                String groupId = rs.getString("group_id");
                List<UUID> members = this.getGroupMembers(groupId);
                groups.add(new GroupConversation(groupId, rs.getString("group_name"), ownerUuid, members, rs.getLong("created_at"), true));
            }
        }
        catch (SQLException e) {
            this.plugin.getNexvorLogger().error("Failed to get active groups", e);
        }
        return groups;
    }

    public List<GroupConversation> getPlayerGroups(UUID playerUuid) {
        ArrayList<GroupConversation> groups = new ArrayList<GroupConversation>();
        String query = "SELECT DISTINCT g.group_id, g.group_name, g.owner_uuid, g.created_at, g.active\nFROM conversation_groups g\nJOIN group_members m ON g.group_id = m.group_id\nWHERE m.player_uuid = ? AND g.active = 1\n";
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(query);){
            stmt.setString(1, playerUuid.toString());
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                UUID ownerUuid = UUID.fromString(rs.getString("owner_uuid"));
                String groupId = rs.getString("group_id");
                List<UUID> members = this.getGroupMembers(groupId);
                groups.add(new GroupConversation(groupId, rs.getString("group_name"), ownerUuid, members, rs.getLong("created_at"), rs.getInt("active") == 1));
            }
        }
        catch (SQLException e) {
            this.plugin.getNexvorLogger().error("Failed to get player groups", e);
        }
        return groups;
    }

    private List<UUID> getGroupMembers(String groupId) {
        ArrayList<UUID> members = new ArrayList<UUID>();
        String query = "SELECT player_uuid FROM group_members WHERE group_id = ?";
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(query);){
            stmt.setString(1, groupId);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                members.add(UUID.fromString(rs.getString("player_uuid")));
            }
        }
        catch (SQLException e) {
            this.plugin.getNexvorLogger().error("Failed to get group members", e);
        }
        return members;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean addMember(String groupId, UUID playerUuid) {
        String insert = "INSERT OR IGNORE INTO group_members (group_id, player_uuid, joined_at) VALUES (?, ?, ?)";
        try (Connection conn = this.databaseManager.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement(insert);
                try {
                    stmt.setString(1, groupId);
                    stmt.setString(2, playerUuid.toString());
                    stmt.setLong(3, System.currentTimeMillis());
                    int rows = stmt.executeUpdate();
                    boolean bl2 = bl = rows > 0;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.plugin.getNexvorLogger().error("Failed to add member to group", e);
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean removeMember(String groupId, UUID playerUuid) {
        String delete = "DELETE FROM group_members WHERE group_id = ? AND player_uuid = ?";
        try (Connection conn = this.databaseManager.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement(delete);
                try {
                    stmt.setString(1, groupId);
                    stmt.setString(2, playerUuid.toString());
                    int rows = stmt.executeUpdate();
                    boolean bl2 = bl = rows > 0;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.plugin.getNexvorLogger().error("Failed to remove member from group", e);
            return false;
        }
    }

    public void saveGroupMessage(String groupId, UUID playerUuid, String role, String content) {
        String insert = "INSERT INTO group_messages (group_id, player_uuid, role, content, timestamp) VALUES (?, ?, ?, ?, ?)";
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(insert);){
            stmt.setString(1, groupId);
            stmt.setString(2, playerUuid != null ? playerUuid.toString() : null);
            stmt.setString(3, role);
            stmt.setString(4, content);
            stmt.setLong(5, System.currentTimeMillis());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getNexvorLogger().error("Failed to save group message", e);
        }
    }

    public List<ChatMessage> getGroupContext(String groupId, int maxMessages) {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        String query = "SELECT role, content FROM group_messages\nWHERE group_id = ?\nORDER BY timestamp DESC\nLIMIT ?\n";
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(query);){
            stmt.setString(1, groupId);
            stmt.setInt(2, maxMessages);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                messages.add(new ChatMessage(rs.getString("role"), rs.getString("content")));
            }
            Collections.reverse(messages);
        }
        catch (SQLException e) {
            this.plugin.getNexvorLogger().error("Failed to get group context", e);
        }
        return messages;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean disbandGroup(String groupId) {
        String update = "UPDATE conversation_groups SET active = 0 WHERE group_id = ?";
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(update);){
            stmt.setString(1, groupId);
            int rows = stmt.executeUpdate();
            if (rows <= 0) return false;
            this.plugin.getNexvorLogger().info("Group disbanded: " + groupId);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.plugin.getNexvorLogger().error("Failed to disband group", e);
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean clearGroupHistory(String groupId) {
        String delete = "DELETE FROM group_messages WHERE group_id = ?";
        try (Connection conn = this.databaseManager.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement(delete);
                try {
                    stmt.setString(1, groupId);
                    int rows = stmt.executeUpdate();
                    this.plugin.getNexvorLogger().info("Cleared " + rows + " messages from group " + groupId);
                    bl = true;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.plugin.getNexvorLogger().error("Failed to clear group history", e);
            return false;
        }
    }
}

