/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.memory;

import com.nexvor.Nexvor;
import com.nexvor.ai.models.ChatMessage;
import com.nexvor.core.NexvorLogger;
import com.nexvor.memory.DatabaseManager;
import com.nexvor.memory.models.Conversation;
import com.nexvor.memory.models.PlayerData;
import com.nexvor.utils.TokenEstimator;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class ConversationManager {
    private final Nexvor plugin;
    private final NexvorLogger logger;
    private final DatabaseManager database;
    private final int maxContextTokens;
    private final int maxMessages;

    public ConversationManager(Nexvor plugin, DatabaseManager database) {
        this.plugin = plugin;
        this.logger = plugin.getNexvorLogger();
        this.database = database;
        this.maxContextTokens = plugin.getConfig().getInt("memory.max_context_tokens", 2048);
        this.maxMessages = plugin.getConfig().getInt("memory.max_messages", 50);
        this.logger.info("Conversation manager initialized: max " + this.maxContextTokens + " tokens, " + this.maxMessages + " messages");
    }

    public List<ChatMessage> getConversationContext(UUID playerUuid, String playerName) {
        this.database.getOrCreatePlayer(playerUuid, playerName);
        List<Conversation> allMessages = this.database.getConversationHistory(playerUuid, this.maxMessages);
        if (allMessages.isEmpty()) {
            this.logger.debug("No conversation history for player " + playerName);
            return new ArrayList<ChatMessage>();
        }
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        int totalTokens = 0;
        for (int i = allMessages.size() - 1; i >= 0; --i) {
            Conversation conv = allMessages.get(i);
            int messageTokens = TokenEstimator.estimateTokens(conv.getContent());
            if (totalTokens + messageTokens > this.maxContextTokens) {
                this.logger.debug("Hit token limit (" + this.maxContextTokens + ") after " + messages.size() + " messages (~" + totalTokens + " tokens)");
                break;
            }
            messages.add(0, new ChatMessage(conv.getRole(), conv.getContent()));
            totalTokens += messageTokens;
        }
        this.logger.debug("Loaded " + messages.size() + " messages (~" + totalTokens + " tokens) for player " + playerName);
        return messages;
    }

    public void saveUserMessage(UUID playerUuid, String playerName, String message) {
        this.database.getOrCreatePlayer(playerUuid, playerName);
        this.database.saveMessage(playerUuid, "user", message);
        this.logger.debug("Saved user message for " + playerName);
    }

    public void saveAssistantMessage(UUID playerUuid, String playerName, String response) {
        this.database.getOrCreatePlayer(playerUuid, playerName);
        this.database.saveMessage(playerUuid, "assistant", response);
        this.logger.debug("Saved assistant message for " + playerName);
    }

    public int clearHistory(UUID playerUuid) {
        int count = this.database.getMessageCount(playerUuid);
        this.database.clearConversationHistory(playerUuid);
        this.logger.info("Cleared conversation history for player " + String.valueOf(playerUuid) + " (" + count + " messages)");
        return count;
    }

    public int getMessageCount(UUID playerUuid) {
        return this.database.getMessageCount(playerUuid);
    }

    public boolean hasHistory(UUID playerUuid) {
        return this.getMessageCount(playerUuid) > 0;
    }

    public PlayerData getPlayerData(UUID playerUuid, String playerName) {
        return this.database.getOrCreatePlayer(playerUuid, playerName);
    }

    public void setOptOut(UUID playerUuid, boolean optedOut) {
        this.database.setOptOut(playerUuid, optedOut);
        this.logger.info("Player " + String.valueOf(playerUuid) + " opt-out status set to: " + optedOut);
    }

    public boolean isOptedOut(UUID playerUuid) {
        return this.database.isOptedOut(playerUuid);
    }

    public int getMaxContextTokens() {
        return this.maxContextTokens;
    }

    public int getMaxMessages() {
        return this.maxMessages;
    }

    public int estimateTokenUsage(UUID playerUuid) {
        int tokens;
        List<Conversation> messages = this.database.getConversationHistory(playerUuid, this.maxMessages);
        int total = 0;
        for (int i = messages.size() - 1; i >= 0 && total < this.maxContextTokens && total + (tokens = TokenEstimator.estimateTokens(messages.get(i).getContent())) <= this.maxContextTokens; total += tokens, --i) {
        }
        return total;
    }
}

