/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.listeners;

import com.nexvor.Nexvor;
import com.nexvor.ai.ProviderManager;
import com.nexvor.ai.models.ChatMessage;
import com.nexvor.ai.models.ChatRequest;
import com.nexvor.core.PluginTier;
import com.nexvor.memory.GlobalChatManager;
import com.nexvor.memory.ProximityChatManager;
import com.nexvor.memory.ProximityGroup;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ChatEventListener
implements Listener {
    private final Nexvor plugin;
    private final String mode;

    public ChatEventListener(Nexvor plugin) {
        this.plugin = plugin;
        this.mode = plugin.getConfigManager().getGroupConversationMode();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (!this.plugin.getConfigManager().isGroupConversationsEnabled()) {
            return;
        }
        if (!this.plugin.hasTier(PluginTier.MEDIUM)) {
            return;
        }
        if (this.mode.equals("private")) {
            return;
        }
        Player player = event.getPlayer();
        String message = event.getMessage();
        if (!this.isDirectedAtAI(message)) {
            return;
        }
        message = this.removeTrigger(message);
        if (this.mode.equals("global")) {
            this.handleGlobalChat(player, message);
        } else if (this.mode.equals("proximity")) {
            this.handleProximityChat(player, message);
        }
    }

    private boolean isDirectedAtAI(String message) {
        String[] triggers;
        String botName = this.plugin.getConfigManager().getBotName().toLowerCase();
        String lowerMessage = message.toLowerCase();
        if (lowerMessage.startsWith(botName) || lowerMessage.startsWith("@" + botName) || lowerMessage.contains(" " + botName + " ") || lowerMessage.contains(" " + botName + ",") || lowerMessage.contains(" " + botName + "!") || lowerMessage.contains(" " + botName + "?")) {
            return true;
        }
        for (String trigger : triggers = new String[]{"ai", "bot", "hey ai", "hey bot"}) {
            if (!lowerMessage.startsWith(trigger + " ") && !lowerMessage.startsWith(trigger + ",")) continue;
            return true;
        }
        return false;
    }

    private String removeTrigger(String message) {
        String botName = this.plugin.getConfigManager().getBotName();
        message = message.replaceFirst("(?i)^@?" + botName + "[,:]?\\s*", "");
        message = message.replaceFirst("(?i)^(ai|bot|hey ai|hey bot)[,:]?\\s*", "");
        return message.trim();
    }

    private void handleGlobalChat(Player player, String message) {
        GlobalChatManager globalManager = this.plugin.getGlobalChatManager();
        if (globalManager == null) {
            return;
        }
        globalManager.savePlayerMessage(player.getUniqueId(), player.getName(), message);
        List<ChatMessage> context = globalManager.getContext();
        this.sendToAI(player, message, context, response -> {
            globalManager.saveAIResponse(response);
            String formattedResponse = "\u00a77[\u00a7bNexvor\u00a77] \u00a7f" + response;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.broadcastMessage((String)formattedResponse));
        });
    }

    private void handleProximityChat(Player player, String message) {
        ProximityChatManager proximityManager = this.plugin.getProximityChatManager();
        if (proximityManager == null) {
            return;
        }
        boolean inGroup = proximityManager.savePlayerMessage(player.getUniqueId(), player.getName(), message);
        if (!inGroup) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage("\u00a77[\u00a7bNexvor\u00a77] \u00a7cYou need at least " + this.plugin.getConfigManager().getProximityChatMinPlayers() + " players nearby to use proximity chat!"));
            return;
        }
        String groupId = proximityManager.getPlayerGroup(player.getUniqueId());
        if (groupId == null) {
            return;
        }
        List<ChatMessage> context = proximityManager.getGroupContext(groupId, 50);
        this.sendToAI(player, message, context, response -> {
            proximityManager.saveAIResponse(groupId, response);
            String formattedResponse = "\u00a77[\u00a7bNexvor\u00a77] \u00a7f" + response;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                ProximityGroup group = proximityManager.getGroup(groupId);
                if (group != null) {
                    for (UUID memberUuid : group.getMembers()) {
                        Player member = Bukkit.getPlayer((UUID)memberUuid);
                        if (member == null || !member.isOnline()) continue;
                        member.sendMessage(formattedResponse);
                    }
                }
            });
        });
    }

    private void sendToAI(Player player, String message, List<ChatMessage> context, ResponseCallback callback) {
        ProviderManager providerManager = this.plugin.getProviderManager();
        if (providerManager == null || !providerManager.hasProvider()) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage("\u00a77[\u00a7bNexvor\u00a77] \u00a7cAI provider not configured!"));
            return;
        }
        ChatRequest.Builder requestBuilder = ChatRequest.builder().model(providerManager.getPrimaryProvider().getDefaultModel()).addSystemMessage(this.plugin.getConfigManager().getSystemPrompt()).temperature(0.7).maxTokens(500);
        for (ChatMessage historyMessage : context) {
            requestBuilder.addMessage(historyMessage);
        }
        requestBuilder.addUserMessage(message);
        ChatRequest request = requestBuilder.build();
        ((CompletableFuture)providerManager.sendRequest(request).thenAccept(response -> {
            if (response.isSuccess()) {
                callback.onResponse(response.getContent());
            } else {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage("\u00a77[\u00a7bNexvor\u00a77] \u00a7cAI request failed: " + response.getErrorMessage()));
            }
        })).exceptionally(ex -> {
            this.plugin.getNexvorLogger().error("AI request failed", (Throwable)ex);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage("\u00a77[\u00a7bNexvor\u00a77] \u00a7cAn error occurred while processing your request."));
            return null;
        });
    }

    @FunctionalInterface
    private static interface ResponseCallback {
        public void onResponse(String var1);
    }
}

