/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.filter;

import java.util.Collections;
import java.util.List;

public class FilterResult {
    private final boolean allowed;
    private final List<String> matchedWords;

    private FilterResult(boolean allowed, List<String> matchedWords) {
        this.allowed = allowed;
        this.matchedWords = matchedWords != null ? matchedWords : Collections.emptyList();
    }

    public static FilterResult allowed() {
        return new FilterResult(true, null);
    }

    public static FilterResult blocked(List<String> matchedWords) {
        return new FilterResult(false, matchedWords);
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public List<String> getMatchedWords() {
        return Collections.unmodifiableList(this.matchedWords);
    }

    public int getMatchCount() {
        return this.matchedWords.size();
    }

    public String toString() {
        if (this.allowed) {
            return "FilterResult{allowed=true}";
        }
        return "FilterResult{allowed=false, matched=" + this.matchedWords.size() + " words}";
    }
}

