/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.core;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.nexvor.Nexvor;
import com.nexvor.core.ServerInfo;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public class ServerActivator {
    private final Nexvor plugin;
    private final HttpClient httpClient;
    private final Gson gson;
    private final String activationUrl;
    private final ServerInfo serverInfo;
    private long lastActivationTime = 0L;
    private static final long ACTIVATION_COOLDOWN_MS = 86400000L;

    public ServerActivator(Nexvor plugin, String activationUrl, ServerInfo serverInfo) {
        this.plugin = plugin;
        this.activationUrl = activationUrl;
        this.serverInfo = serverInfo;
        this.gson = new Gson();
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    }

    public CompletableFuture<Boolean> activateAsync(String licenseKey) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastActivationTime < 86400000L) {
            this.plugin.getNexvorLogger().debug("Server activation on cooldown, skipping");
            return CompletableFuture.completedFuture(true);
        }
        try {
            JsonObject requestBody = new JsonObject();
            requestBody.addProperty("licenseKey", licenseKey);
            requestBody.addProperty("serverUuid", this.serverInfo.getServerUuid());
            requestBody.addProperty("serverName", this.serverInfo.getServerName());
            requestBody.addProperty("serverIp", this.serverInfo.getServerIp());
            requestBody.addProperty("minecraftVersion", this.serverInfo.getBukkitVersion());
            requestBody.addProperty("pluginVersion", this.plugin.getDescription().getVersion());
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.activationUrl)).header("Content-Type", "application/json").header("User-Agent", "Nexvor/" + this.plugin.getDescription().getVersion()).POST(HttpRequest.BodyPublishers.ofString(this.gson.toJson(requestBody))).timeout(Duration.ofSeconds(15L)).build();
            return ((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
                if (response.statusCode() == 200) {
                    try {
                        boolean success;
                        JsonObject responseBody = this.gson.fromJson((String)response.body(), JsonObject.class);
                        boolean bl = success = responseBody.has("success") && responseBody.get("success").getAsBoolean();
                        if (success) {
                            this.lastActivationTime = currentTime;
                            this.plugin.getNexvorLogger().info("Server activated successfully");
                            if (responseBody.has("serverId")) {
                                this.plugin.getNexvorLogger().debug("Server ID: " + responseBody.get("serverId").getAsInt());
                            }
                            return true;
                        }
                        String message = responseBody.has("message") ? responseBody.get("message").getAsString() : "Unknown error";
                        this.plugin.getNexvorLogger().warn("Server activation failed: " + message);
                        return false;
                    }
                    catch (Exception e) {
                        this.plugin.getNexvorLogger().warn("Failed to parse activation response: " + e.getMessage());
                        return false;
                    }
                }
                if (response.statusCode() == 403) {
                    this.plugin.getNexvorLogger().warn("Server activation failed: License activation limit reached");
                    return false;
                }
                this.plugin.getNexvorLogger().warn("Server activation failed with status code: " + response.statusCode());
                return false;
            })).exceptionally(throwable -> {
                this.plugin.getNexvorLogger().debug("Server activation request failed: " + throwable.getMessage());
                return false;
            });
        }
        catch (Exception e) {
            this.plugin.getNexvorLogger().warn("Failed to create activation request: " + e.getMessage());
            return CompletableFuture.completedFuture(false);
        }
    }

    public void resetCooldown() {
        this.lastActivationTime = 0L;
    }

    public void shutdown() {
    }
}

