/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.core;

public enum PluginTier {
    BASIC(0, "Basic", true),
    MEDIUM(1, "Medium", false),
    MAX(2, "Max", false);

    private final int level;
    private final String displayName;
    private final boolean free;

    private PluginTier(int level, String displayName, boolean free) {
        this.level = level;
        this.displayName = displayName;
        this.free = free;
    }

    public int getLevel() {
        return this.level;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isFree() {
        return this.free;
    }

    public boolean includes(PluginTier other) {
        return this.level >= other.level;
    }

    public boolean isHigherThan(PluginTier other) {
        return this.level > other.level;
    }

    public static PluginTier fromString(String name) {
        if (name == null) {
            return BASIC;
        }
        for (PluginTier tier : PluginTier.values()) {
            if (!tier.name().equalsIgnoreCase(name)) continue;
            return tier;
        }
        return BASIC;
    }
}

