/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.core;

import com.nexvor.Nexvor;
import com.nexvor.core.LicenseResponse;
import com.nexvor.core.LicenseValidator;
import com.nexvor.core.PluginTier;
import com.nexvor.core.ServerActivator;
import com.nexvor.core.ServerInfo;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class LicenseManager {
    private final Nexvor plugin;
    private PluginTier activeTier;
    private String licenseKey;
    private boolean validated = false;
    private boolean onlineValidation = false;
    private LicenseValidator validator;
    private ServerActivator activator;
    private int customerId = -1;

    public LicenseManager(Nexvor plugin) {
        this.plugin = plugin;
        this.activeTier = PluginTier.BASIC;
    }

    public PluginTier validateLicense(String configLicenseKey, String validationUrl, String activationUrl, ServerInfo serverInfo) {
        this.licenseKey = configLicenseKey;
        if (this.licenseKey == null || this.licenseKey.isEmpty() || this.licenseKey.equals("none")) {
            this.activeTier = PluginTier.BASIC;
            this.validated = true;
            this.plugin.getNexvorLogger().info("Running in BASIC tier (Free)");
            return this.activeTier;
        }
        this.validator = new LicenseValidator(this.plugin, validationUrl);
        this.activator = new ServerActivator(this.plugin, activationUrl, serverInfo);
        this.plugin.getNexvorLogger().info("Validating license online...");
        try {
            LicenseResponse response = this.validator.validateAsync(this.licenseKey).get(15L, TimeUnit.SECONDS);
            if (response.isValid()) {
                this.activeTier = response.getPluginTier();
                this.customerId = response.getCustomerId();
                this.validated = true;
                this.onlineValidation = true;
                this.plugin.getNexvorLogger().info("License validated online! Running in " + this.activeTier.getDisplayName().toUpperCase() + " tier");
                this.plugin.getNexvorLogger().info("Customer ID: " + this.customerId);
                this.activator.activateAsync(this.licenseKey).thenAccept(success -> {
                    if (success.booleanValue()) {
                        this.plugin.getNexvorLogger().debug("Server activation completed");
                    }
                });
                return this.activeTier;
            }
            this.plugin.getNexvorLogger().warn("License validation failed: " + (response.getMessage() != null ? response.getMessage() : "Invalid license key"));
            this.plugin.getNexvorLogger().warn("Falling back to BASIC tier");
            this.plugin.getNexvorLogger().warn("If you purchased a license, please verify your key or contact support");
            this.activeTier = PluginTier.BASIC;
            this.validated = false;
            this.onlineValidation = false;
            return this.activeTier;
        }
        catch (Exception e) {
            this.plugin.getNexvorLogger().warn("Online validation failed: " + e.getMessage());
            this.plugin.getNexvorLogger().warn("Attempting offline validation...");
            PluginTier offlineTier = this.validateKeyOffline(this.licenseKey);
            if (offlineTier != null && offlineTier != PluginTier.BASIC) {
                this.activeTier = offlineTier;
                this.validated = true;
                this.onlineValidation = false;
                this.plugin.getNexvorLogger().warn("License validated OFFLINE! Running in " + offlineTier.getDisplayName().toUpperCase() + " tier");
                this.plugin.getNexvorLogger().warn("Note: Some features may require online validation");
                this.plugin.getNexvorLogger().warn("Please check your internet connection or firewall settings");
            } else {
                this.activeTier = PluginTier.BASIC;
                this.validated = false;
                this.onlineValidation = false;
                this.plugin.getNexvorLogger().warn("License validation failed! Falling back to BASIC tier");
                this.plugin.getNexvorLogger().warn("If you purchased a license, please check your key in config.yml");
            }
            return this.activeTier;
        }
    }

    private PluginTier validateKeyOffline(String key) {
        if (key.toUpperCase().startsWith("MEDIUM-")) {
            String uuid = key.substring(7);
            try {
                UUID.fromString(uuid);
                return PluginTier.MEDIUM;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        if (key.toUpperCase().startsWith("MAX-")) {
            String uuid = key.substring(4);
            try {
                UUID.fromString(uuid);
                return PluginTier.MAX;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    public PluginTier getActiveTier() {
        return this.activeTier;
    }

    public boolean hasTier(PluginTier tier) {
        return this.activeTier.includes(tier);
    }

    public boolean isValidated() {
        return this.validated;
    }

    public String getLicenseKeySanitized() {
        if (this.licenseKey == null || this.licenseKey.isEmpty() || this.licenseKey.equals("none")) {
            return "none";
        }
        if (this.licenseKey.length() > 12) {
            return this.licenseKey.substring(0, 8) + "****";
        }
        return "****";
    }

    public boolean isOnlineValidation() {
        return this.onlineValidation;
    }

    public int getCustomerId() {
        return this.customerId;
    }

    public PluginTier revalidate(String validationUrl, String activationUrl, ServerInfo serverInfo) {
        if (this.validator != null) {
            this.validator.clearCache();
        }
        if (this.activator != null) {
            this.activator.resetCooldown();
        }
        return this.validateLicense(this.licenseKey, validationUrl, activationUrl, serverInfo);
    }

    public void shutdown() {
        if (this.validator != null) {
            this.validator.shutdown();
        }
        if (this.activator != null) {
            this.activator.shutdown();
        }
    }

    public static String generateSampleKey(PluginTier tier) {
        if (tier == PluginTier.BASIC) {
            return "none";
        }
        String prefix = tier == PluginTier.MEDIUM ? "MEDIUM-" : "MAX-";
        return prefix + UUID.randomUUID().toString();
    }
}

