/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.commands.subcommands;

import com.nexvor.Nexvor;
import com.nexvor.ai.ProviderManager;
import com.nexvor.ai.models.ChatMessage;
import com.nexvor.ai.models.ChatRequest;
import com.nexvor.commands.BaseCommand;
import com.nexvor.filter.FilterResult;
import com.nexvor.filter.LanguageFilter;
import com.nexvor.memory.ConversationManager;
import com.nexvor.ratelimit.RateLimitManager;
import com.nexvor.ratelimit.RateLimitResult;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ChatCommand
extends BaseCommand {
    public ChatCommand(Nexvor plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        FilterResult filterResult;
        RateLimitResult rateLimitResult;
        if (args.length == 0) {
            return false;
        }
        if (!(sender instanceof Player)) {
            this.sendError(sender, "This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        ProviderManager providerManager = this.plugin.getProviderManager();
        if (providerManager == null || !providerManager.hasProvider()) {
            this.sendError(sender, "AI provider not initialized! Check server logs for errors.");
            return true;
        }
        ConversationManager conversationManager = this.plugin.getConversationManager();
        if (conversationManager == null) {
            this.sendError(sender, "Conversation manager not initialized! Check server logs.");
            return true;
        }
        UUID playerUuid = player.getUniqueId();
        String playerName = player.getName();
        RateLimitManager rateLimitManager = this.plugin.getRateLimitManager();
        if (rateLimitManager != null && !(rateLimitResult = rateLimitManager.checkAllowed(player)).isAllowed()) {
            this.sendMessage(sender, rateLimitResult.getMessage());
            return true;
        }
        if (conversationManager.isOptedOut(playerUuid)) {
            this.sendError(sender, "You have opted out of using the AI chatbot.");
            this.sendMessage(sender, "\u00a77Use /nexvor privacy to manage your privacy settings.");
            return true;
        }
        String message = String.join((CharSequence)" ", args);
        LanguageFilter languageFilter = this.plugin.getLanguageFilter();
        if (languageFilter != null && languageFilter.isEnabled() && !(filterResult = languageFilter.check(message)).isAllowed()) {
            this.sendError(sender, "Your message contains inappropriate language.");
            this.sendMessage(sender, "\u00a77Please rephrase your message without offensive words.");
            this.plugin.getNexvorLogger().info("Blocked message from " + playerName + " (language filter): " + filterResult.getMatchCount() + " words");
            return true;
        }
        this.sendMessage(sender, "\u00a77" + this.plugin.getConfigManager().getBotName() + " is thinking...");
        List<ChatMessage> conversationHistory = conversationManager.getConversationContext(playerUuid, playerName);
        ChatRequest.Builder requestBuilder = ChatRequest.builder().model(providerManager.getPrimaryProvider().getDefaultModel()).addSystemMessage(this.plugin.getConfigManager().getSystemPrompt()).temperature(0.7).maxTokens(500);
        for (ChatMessage historyMessage : conversationHistory) {
            if (historyMessage.getRole().equals("user")) {
                requestBuilder.addUserMessage(historyMessage.getContent());
                continue;
            }
            if (!historyMessage.getRole().equals("assistant")) continue;
            requestBuilder.addAssistantMessage(historyMessage.getContent());
        }
        requestBuilder.addUserMessage(message);
        ChatRequest request = requestBuilder.build();
        conversationManager.saveUserMessage(playerUuid, playerName, message);
        ((CompletableFuture)providerManager.sendRequest(request).thenAccept(response -> this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            if (!response.isSuccess()) {
                this.sendError(sender, "Failed to get response: " + response.getErrorMessage());
                this.plugin.getNexvorLogger().severe("Chat error for " + playerName + ": " + response.getErrorMessage());
                return;
            }
            String aiResponse = response.getContent();
            conversationManager.saveAssistantMessage(playerUuid, playerName, aiResponse);
            if (rateLimitManager != null) {
                rateLimitManager.recordRequest(player);
            }
            String botName = this.plugin.getConfigManager().getBotName();
            sender.sendMessage("\u00a77[\u00a7b" + botName + "\u00a77] \u00a7f" + aiResponse);
            this.plugin.getNexvorLogger().debug("Chat response for " + playerName + " - Tokens: " + response.getTotalTokens() + " (prompt: " + response.getPromptTokens() + ", completion: " + response.getCompletionTokens() + ") - History size: " + conversationManager.getMessageCount(playerUuid));
        }))).exceptionally(throwable -> {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                this.sendError(sender, "An error occurred while contacting the AI.");
                this.plugin.getNexvorLogger().error("Chat exception for " + playerName, (Throwable)throwable);
            });
            return null;
        });
        return true;
    }

    @Override
    public String getName() {
        return "chat";
    }

    @Override
    public String getDescription() {
        return "Chat with the AI bot";
    }

    @Override
    public String getUsage() {
        return "/nexvor chat <message>";
    }

    @Override
    public String getPermission() {
        return "nexvor.chat";
    }
}

