/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.ai.providers;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nexvor.Nexvor;
import com.nexvor.ai.AIProvider;
import com.nexvor.ai.APIClient;
import com.nexvor.ai.models.ChatMessage;
import com.nexvor.ai.models.ChatRequest;
import com.nexvor.ai.models.ChatResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class CustomProvider
implements AIProvider {
    private final Nexvor plugin;
    private final APIClient apiClient;
    private final String name;
    private final String baseUrl;
    private final String apiKey;
    private final String model;
    private final Map<String, String> customHeaders;

    public CustomProvider(Nexvor plugin, String name, String baseUrl, String apiKey, String model) {
        this(plugin, name, baseUrl, apiKey, model, new HashMap<String, String>());
    }

    public CustomProvider(Nexvor plugin, String name, String baseUrl, String apiKey, String model, Map<String, String> customHeaders) {
        this.plugin = plugin;
        this.apiClient = new APIClient(plugin);
        this.name = name != null && !name.isEmpty() ? name : "custom";
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
        this.model = model;
        this.customHeaders = customHeaders != null ? customHeaders : new HashMap();
    }

    @Override
    public CompletableFuture<ChatResponse> sendRequest(ChatRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String json = this.buildRequestJson(request);
                Object url = this.baseUrl;
                if (!((String)url).endsWith("/chat/completions")) {
                    if (!((String)url).endsWith("/")) {
                        url = (String)url + "/";
                    }
                    url = (String)url + "chat/completions";
                }
                String responseJson = this.apiClient.postAsync((String)url, json, this.apiKey, this.customHeaders).join();
                return this.parseResponse(responseJson);
            }
            catch (Exception e) {
                this.plugin.getNexvorLogger().warn(this.name + " API error: " + e.getMessage());
                return ChatResponse.error("Failed to get response from " + this.name + ": " + e.getMessage());
            }
        });
    }

    private String buildRequestJson(ChatRequest request) {
        JsonObject root = new JsonObject();
        root.addProperty("model", request.getModel());
        root.addProperty("temperature", request.getTemperature());
        root.addProperty("max_tokens", request.getMaxTokens());
        JsonArray messages = new JsonArray();
        for (ChatMessage msg : request.getMessages()) {
            JsonObject message = new JsonObject();
            message.addProperty("role", msg.getRole());
            message.addProperty("content", msg.getContent());
            messages.add(message);
        }
        root.add("messages", messages);
        return root.toString();
    }

    private ChatResponse parseResponse(String json) {
        try {
            JsonObject root = JsonParser.parseString(json).getAsJsonObject();
            String content = root.getAsJsonArray("choices").get(0).getAsJsonObject().getAsJsonObject("message").get("content").getAsString();
            int promptTokens = 0;
            int completionTokens = 0;
            int totalTokens = 0;
            if (root.has("usage")) {
                JsonObject usage = root.getAsJsonObject("usage");
                if (usage.has("prompt_tokens")) {
                    promptTokens = usage.get("prompt_tokens").getAsInt();
                }
                if (usage.has("completion_tokens")) {
                    completionTokens = usage.get("completion_tokens").getAsInt();
                }
                if (usage.has("total_tokens")) {
                    totalTokens = usage.get("total_tokens").getAsInt();
                }
            }
            String responseModel = root.has("model") ? root.get("model").getAsString() : this.model;
            return ChatResponse.builder().content(content).model(responseModel).promptTokens(promptTokens).completionTokens(completionTokens).totalTokens(totalTokens).success(true).build();
        }
        catch (Exception e) {
            this.plugin.getNexvorLogger().warn("Failed to parse " + this.name + " response: " + e.getMessage());
            return ChatResponse.error("Failed to parse response: " + e.getMessage());
        }
    }

    @Override
    public String getProviderName() {
        return this.name;
    }

    @Override
    public boolean isConfigured() {
        return this.baseUrl != null && !this.baseUrl.isEmpty() && this.apiKey != null && !this.apiKey.isEmpty() && this.model != null && !this.model.isEmpty();
    }

    @Override
    public String getDefaultModel() {
        return this.model;
    }

    @Override
    public boolean validateApiKey(String apiKey) {
        return apiKey != null && !apiKey.isEmpty() && apiKey.length() > 10;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void shutdown() {
        this.apiClient.shutdown();
    }
}

