/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.ai.models;

import com.nexvor.ai.models.ChatMessage;
import java.util.ArrayList;
import java.util.List;

public class ChatRequest {
    private final List<ChatMessage> messages;
    private final String model;
    private final double temperature;
    private final int maxTokens;

    private ChatRequest(Builder builder) {
        this.messages = builder.messages;
        this.model = builder.model;
        this.temperature = builder.temperature;
        this.maxTokens = builder.maxTokens;
    }

    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    public String getModel() {
        return this.model;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<ChatMessage> messages = new ArrayList<ChatMessage>();
        private String model;
        private double temperature = 0.7;
        private int maxTokens = 1000;

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder addMessage(ChatMessage message) {
            this.messages.add(message);
            return this;
        }

        public Builder addSystemMessage(String content) {
            this.messages.add(ChatMessage.system(content));
            return this;
        }

        public Builder addUserMessage(String content) {
            this.messages.add(ChatMessage.user(content));
            return this;
        }

        public Builder addAssistantMessage(String content) {
            this.messages.add(ChatMessage.assistant(content));
            return this;
        }

        public Builder messages(List<ChatMessage> messages) {
            this.messages = new ArrayList<ChatMessage>(messages);
            return this;
        }

        public Builder temperature(double temperature) {
            this.temperature = Math.max(0.0, Math.min(2.0, temperature));
            return this;
        }

        public Builder maxTokens(int maxTokens) {
            this.maxTokens = Math.max(1, maxTokens);
            return this;
        }

        public ChatRequest build() {
            if (this.model == null || this.model.isEmpty()) {
                throw new IllegalStateException("Model must be specified");
            }
            if (this.messages.isEmpty()) {
                throw new IllegalStateException("At least one message is required");
            }
            return new ChatRequest(this);
        }
    }
}

